Texture2D MaskMap;

SamplerState sMask {
	Filter        = MIN_MAG_MIP_LINEAR;
	AddressU      = WRAP;
	AddressV      = WRAP;
	MaxAnisotropy = MAXANISOTROPY_DEFAULT;
	BorderColor   = float4(0, 0, 0, 0);
};

float4 Color;
float isON;

struct vsLBOutput{
	float4 vPosition:	SV_POSITION;
	float4 projPos : TEXCOORD0;
};

vsLBOutput vsStandart_LB(in float3 vPosition: POSITION){		
	vsLBOutput o;
	
	o.vPosition = o.projPos = mul(float4(vPosition, 1.0), matWorldViewProj);
	
	return o;
}

float4 psStandart_LB(in const vsLBOutput i) : SV_TARGET0 {
	float2 UV = (i.projPos.xy / i.projPos.w + 1.0) * 0.5;
	UV.y = 1.0 - UV.y;
	float mask = MaskMap.Sample(sMask, UV).r;
	return float4(Color.rgb, mask);
}

///////////////////////////////////////////
// CUSTOM NVG START
///////////////////////////////////////////

#include <../common/MOD_nvg.hlsl>

float4 psStandart_LB_NVG(in const vsLBOutput i) : SV_TARGET0 {
  float2 UV = (i.projPos.xy / i.projPos.w + 1.0) * 0.5;
  UV.y = 1.0 - UV.y;
  float mask = maskNVG(UV).x;
  return float4(Color.rgb, mask);
  //return float4(Color.rgb, 0);  //bug testing
}

///////////////////////////////////////////
// CUSTOM NVG END
///////////////////////////////////////////

float4 psNoMask_LB(in const vsLBOutput i) : SV_TARGET0 {
	return Color;
}

vertexshader vs_lb = compile vs_4_0 vsStandart_LB();
pixelshader ps_lb_0 = compile ps_4_0 psStandart_LB_NVG(); // Changed for custom NVGs, revert to psStandart_LB() for default.
//pixelshader ps_lb_0 = compile ps_4_0 psStandart_LB();
pixelshader ps_lb_1 = compile ps_4_0 psNoMask_LB();

technique10 Standart_LB{
	pass P0{
		SetRasterizerState(cullNone);
		SetDepthStencilState(enableDepthBuffer, 0);
		SetBlendState(enableAlphaBlend, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);

		VertexShader = vs_lb;
		PixelShader  = ps_lb_0; 
	}
}

technique10 NoMask_LB{
	pass P0{
		SetRasterizerState(cullNone);
		SetDepthStencilState(enableDepthBuffer, 0);
		SetBlendState(enableAlphaBlend, float4(0.0f, 0.0f, 0.0f, 0.0f), 0xFFFFFFFF);	

		VertexShader = vs_lb;
		PixelShader  = ps_lb_1; 
	}
}
